-- GROUP BY: select sorgularnda ihtiyaca gre bir veya daha fazla stun gruplanarak
-- gruplanan stun ile birlikte saysal veri tipindeki dier bir veya daha fazla stun
-- zerinde SUM, MIN, MAX, AVG ve COUNT aggregate function'lar altrlabilir.
-- Tarih tipindeki veriler iin de MAX, MIN ve COUNT aggregate function'lar altrlabilir.
-- Aggregate function'larla kullanlan stunlar dnda select yanna yazlan tm stunlar
-- group by'dan sonra yazlmaldr.

-- 1) COUNT: Gruplanan stun veya stunlara gre kayt saysn baka bir stunda getirir.
use Filmler
select yapimyili, COUNT(*) sayi from Film group by yapimyili
-- Yapm ylna gre film saysn getiren sorgu.

-- group by join sorgularndan sonra da kullanlabilir.
-- count(*) genelde kayt saysn getirmek iin kullanlr ancak null verilerin saylp saylmayacana gre
-- count(stun ad) da kullanlabilir.
select y.adi, y.soyadi, count(f.Id) filmsayisi
from Yonetmen y inner join Film f on y.Id = f.yonetmenId
group by y.adi, y.soyadi
-- rneimizde her bir ynetmen iin bir film kayd oluturduumuzdan her bir ynetmen iin film says 1 olarak gelecektir.

-- HAVING: group by'dan sonra herhangi bir aggregate function (COUNT, SUM, MIN, MAX, AVG) kullanlan stun zerinden 
-- filtreleme yaplmasn salar.
select y.adi, y.soyadi, count(f.Id) filmsayisi
from Yonetmen y inner join Film f on y.Id = f.yonetmenId
group by y.adi, y.soyadi
having count(f.Id) > 1
-- rneimizde her bir ynetmen iin bir film kayd oluturduumuzdan her bir ynetmen iin film says 1 olarak gelecektir,
-- bu yzden having filtresi ile kayt says 1'den byk olan kaytlar getir dediimizden sonu dnmeyecektir.

select t.adi as turadi, count(*) filmsayisi 
from tur t inner join filmtur ft on t.Id = ft.turId
inner join film f on ft.filmId = f.Id
group by t.adi
-- Tr adna gre film saysn getiren sorgu.

-- 2) SUM: Gruplanan stun veya stunlara gre baka bir stunun toplam sonucunun hesaplanmas iin kullanlr.
select f.yapimyili, sum(f.gisesi) as toplamgise, sum(fd.maliyeti) as toplammaliyet from Film f left outer join FilmDetay fd on f.Id = fd.FilmId
group by f.yapimyili
-- Yapm ylna gre filmlerin toplam giesini ve maliyetini getiren sorgu.

select t.adi as turadi, sum(f.gisesi) as filmtoplamgise 
from tur t left outer join filmtur ft on t.Id = ft.turId
left outer join film f on ft.filmId = f.Id
group by t.adi
having sum(f.gisesi) >= 1000000.00 and sum(f.gisesi) <= 2000000.00
-- Tr adna gre filmlerin toplam gielerini 1000000 ile 2000000 arasnda olacak ekilde filtreleyerek getiren sorgu.

-- 3) MAX: Gruplanan stun veya stunlara gre baka bir stunun maksimum sonucunun hesaplanmas iin kullanlr.
select emeklimi, max(dogumtarihi) maksimumdogumtarihi from yonetmen where emeklimi is not null group by emeklimi
-- Ynetmen tablosunda emekli verisi null olmayan kaytlar zerinden emeklimi stununa gre gruplama yap ve 
-- bu gruplamaya gre maksimum doum tarihlerini getir.

-- 4) MIN: Gruplanan stun veya stunlara gre baka bir stunun minimum sonucunun hesaplanmas iin kullanlr.
select yapimyili YapmYl, min(gisesi) Giesi from film group by yapimyili having yapimyili < 2000
-- Film tablosunda yapm ylna gre minimum gieye sahip filmlerin yapm yl ve gielerini 2000 ylndan ncesi olarak getirir.

-- 5) AVG: Gruplanan stun veya stunlara gre baka bir stunun ortalama sonucunun hesaplanmas iin kullanlr.
select t.Id as turid, t.adi as turadi, AVG(f.gisesi) as filmortalamagise 
from tur t inner join filmtur ft on t.Id = ft.turId
inner join film f on ft.filmId = f.Id
where t.Id in (2, 3, 4) -- bilim kurgu, aksiyon, dram
group by t.Id, t.adi
-- Tr bilim kurgu, aksiyon ve dram olan film tr join sorgusu sonucu zerinden tr id ve tr ad stunlarna 
-- gre gruplama yaparak film gielerinin ortalama sonucunu getirir.